/*

Macro Scripts File
Created:   13 Sept 2010: Max 2012
Author:   Stephen Taylor

MacroScripts for the new MassFX physics system

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK


-- Rigid Bodies
MacroScript PxSetSelAsDynRigidBodyMS
ButtonText:~PXSETSELASDYNRIGIDBODY_BUTTONTEXT~
Tooltip:~PXSETSELASDYNRIGIDBODY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/SetSelectedAsDynamicRigidBody"
(
	on isEnabled  do (currentNode = PxGetCurrentNode(); return currentNode !=undefined)
	On Execute Do (	PxCreateAsDynamic() )
)

MacroScript PxSetSelAsKinRigidBodyMS
ButtonText:~PXSETSELASKINEMATICRIGIDBODY_BUTTONTEXT~
Tooltip:~PXSETSELASKINEMATICRIGIDBODY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/SetSelectedAsKinematicRigidBody"
(
	on isEnabled  do (currentNode = PxGetCurrentNode(); return currentNode !=undefined)
	On Execute Do (	PxCreateAsKinetic() )
)

MacroScript PxSetSelAsStaticRigidBodyMS
ButtonText:~PXSETSELASSTATICRIGIDBODY_BUTTONTEXT~
Tooltip:~PXSETSELASSTATICRIGIDBODY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/SetSelectedAsStaticRigidBody"
(
	on isEnabled  do (currentNode = PxGetCurrentNode(); return currentNode !=undefined)
	On Execute Do (	PxCreateAsStatic() )
)

MacroScript PxCreateDynamicSkeletonMS
ButtonText:~PXCREATEDYNAMICSKELETON_BUTTONTEXT~
Tooltip:~PXCREATEDYNAMICSKELETON_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateDynamicRagdoll"
(
		on isEnabled  do 
		(
			currentNode = PxGetCurrentNode()			
			return currentNode !=undefined and PxPotentialRagdollHelper(currentNode)
		)
	On Execute Do (	PxCreateDynamicRagdollHelper() )
)

MacroScript PxCreateKinematicSkeletonMS
ButtonText:~PXCREATEKINEMATICSKELETON_BUTTONTEXT~
Tooltip:~PXCREATEKINEMATICSKELETON_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateKinematicRagdoll"
(
		on isEnabled  do 
		(
			currentNode = PxGetCurrentNode()			
			return currentNode !=undefined and PxPotentialRagdollHelper(currentNode)
		)
	On Execute Do (	PxCreateKinematicRagdollHelper() )
)

MacroScript PxRemoveSkeletonMS
ButtonText:~PXREMOVERAGDOLL_BUTTONTEXT~
Tooltip:~PXREMOVERAGDOLL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/RemoveRagdoll"
(
	On Execute Do (	PxRemoveRagdollHelper()	)
)


-- Constraints
MacroScript PxCreateRigidConstraintMS
ButtonText:~PXCREATERIGIDCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATERIGIDCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateRigidConstraint"
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintRigidMode))
	On Execute Do (	PxCreateConstrintRigid() )
)

MacroScript PxCreateSlideConstraintMS
ButtonText:~PXCREATESLIDECONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATESLIDECONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateSlideConstraint"
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintSlideMode))
	On Execute Do (	PxCreateConstrintSlide() )
)

MacroScript PxCreateHingeConstraintMS
ButtonText:~PXCREATEHINGECONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATEHINGECONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateHingeConstraint"
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintHingeMode))
	On Execute Do (	PxCreateConstrintHinge() )
)

MacroScript PxCreateTwistConstraintMS
ButtonText:~PXCREATETWISTCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATETWISTCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateTwistConstraint"
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintTwistMode))
	On Execute Do (	PxCreateConstrintTwist() )
)

MacroScript PxCreateBallAndSocketConstraintMS
ButtonText:~PXCREATEBALLANDSOCKETCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATEBALLANDSOCKETCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateBallSocketConstraint"
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintBallSocketMode))
	On Execute Do (	PxCreateConstrintBallSocket() )
)

MacroScript PxCreateUniversalConstraintMS
ButtonText:~PXCREATEUNIVERSALCONSTRAINT_BUTTONTEXT~
Tooltip:~PXCREATEUNIVERSALCONSTRAINT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/CreateUniversalConstraint"
(
	on IsEnabled do ( selection.count == 1 or selection.count == 2)
	--on isChecked do (return (gPxCreateConstraintTypeFlag == gPxCreateConstraintUnivMode))
	On Execute Do (	PxCreateConstrintUniv() )
)

MacroScript PxRemoveConstraintMS
ButtonText:~PXREMOVECONST_BUTTONTEXT~
Tooltip:~PXREMOVECONST_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	on IsEnabled do ( gPxCreateConstraintTypeFlag != 0)
	On Execute Do (	PxCreateAs PX_PHYSTYPE_UNDEFINED )
)


-- MassFX Cloth

MacroScript PxCreateClothMS
ButtonText:~PXCREATECLOTH_BUTTONTEXT~
Tooltip:~PXCREATECLOTH_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MainUI/MCloth"
(
	On Execute Do (	PxCreateAsCloth() )
)

MacroScript PxRemoveClothMS
ButtonText:~PXREMOVECLOTH_BUTTONTEXT~
Tooltip:~PXREMOVECLOTH_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/RemoveMCloth"
(
	On Execute Do (	PxRemoveCloth() )
)



-- Simulation
MacroScript PxPlaySimMS
ButtonText:~PXPLAYSIM_BUTTONTEXT~
Tooltip:~PXPLAYSIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/StartSimulation"
(
	on isChecked do
	(
		return PxIsSimulationRunning() and nvpx.GetAnimationState()
	)
	on execute do
	(
		-- Set simulation type (with or without animation) if command will start simulation
		if not PxIsSimulationRunning() do nvpx.SetAnimationState(true)

		PxRunSimulation() -- Start or stop simulation
	)
)

macroScript PxPlaySimWithoutAnimMS
ButtonText:~PXPLAYSIMWITHOUTANIM_BUTTONTEXT~
Tooltip:~PXPLAYSIMWITHOUTANIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/StartSimulationWithoutAnimation"
(
	on isChecked do
	(
		return PxIsSimulationRunning() and not nvpx.GetAnimationState()
	)
	on execute do
	(
		-- Set simulation type (with or without animation) if command will start simulation
		if not PxIsSimulationRunning() do nvpx.SetAnimationState(false)

		PxRunSimulation() -- Start or stop simulation
	)
)

MacroScript PxStepSimMS
ButtonText:~PXSTEPSIM_BUTTONTEXT~
Tooltip:~PXSTEPSIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/AdvanceSimulationOneFrame"
(
	On Execute Do (	PxStepSimulation() )
)

MacroScript PxResetSimMS
ButtonText:~PXRESETSIM_BUTTONTEXT~
Tooltip:~PXRESETSIM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/ResetSimulation"
(
	On Execute Do (	PxStopSimulation() )
)


-- Baking
MacroScript PxBakeAllMS
ButtonText:~PXBAKEALL_BUTTONTEXT~
Tooltip:~PXBAKEALL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	pxBakeAll false )
)

MacroScript PxBakeSelMS
ButtonText:~PXBAKESEL_BUTTONTEXT~
Tooltip:~PXBAKESEL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	on IsEnabled do ( selection.count != 0 )
	On Execute Do (	pxBakeSelection false )
)

MacroScript PxUnBakeAllMS
ButtonText:~PXUNBAKEALL_BUTTONTEXT~
Tooltip:~PXUNBAKEALL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	pxBakeAll true )
)

MacroScript PxUnBakeSelMS
ButtonText:~PXUNBAKESEL_BUTTONTEXT~
Tooltip:~PXUNBAKESEL_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	on IsEnabled do ( selection.count != 0 )
	On Execute Do (	pxBakeSelection true )
)


-- Utilities
MacroScript PxValidateSceneMS
ButtonText:~PXVALIDATESCENE_BUTTONTEXT~
Tooltip:~PXVALIDATESCENE_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	nvpx.ShowValidateScene false)
)

MacroScript PxExportSceneMS
ButtonText:~PXEXPORTSCENE_BUTTONTEXT~
Tooltip:~PXEXPORTSCENE_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	 PxExportPxProj_Prompting false )
)

MacroScript PxCaptureCurrXFormMS
ButtonText:~PXCAPTURECURRXFORM_BUTTONTEXT~
Tooltip:~PXCAPTURECURRXFORM_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do ( PxCaptureTransform(false) )
)

MacroScript PxAboutBoxMS
ButtonText:~PXABOUT_BUTTONTEXT~
Tooltip:~PXABOUT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
(
	On Execute Do (	PxShowAbout() )
)

MacroScript PxShowToolsWindowMS
ButtonText:~PXSHOWTOOLSWINDOW_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOW_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/WorldParameters"
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(1)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowWorldMS
ButtonText:~PXSHOWTOOLSWINDOWWORLD_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWWORLD_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/WorldParameters"
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==1) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(1)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowToolsMS
ButtonText:~PXSHOWTOOLSWINDOWTOOLS_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWTOOLS_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/SimulationTools"
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==2) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(2)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowMultiEditMS
ButtonText:~PXSHOWTOOLSWINDOWMULTIEDIT_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWMULTIEDIT_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
IconName:"MassFX/MultiObjectEditor"
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==3) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(3)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

MacroScript PxShowToolsWindowDisplayMS
ButtonText:~PXSHOWTOOLSWINDOWDISPLAY_BUTTONTEXT~
Tooltip:~PXSHOWTOOLSWINDOWDISPLAY_TOOLTIP~ 
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
Icon:#("PhysX_Main",29)
(
	On isChecked do ( px_physXPanel.open )
	On Execute Do 
	(	
		if (px_physXPanel.open) and (px_physXPanel.GetCurrentPage()==4) then (
			PxPanelClose()
		)
		else (
			PxShowPhysicsPanel(4)
		)
	)
	On closeDialogs do ( PxPanelClose() ) 
)

macroScript OpenDynamicsExplorer 
ButtonText:~OPENDYNAMICSEXPLORER_BUTTONTEXT~
category:~PXPHYSX_CATEGORY~ 
internalCategory:"PhysX" 
tooltip:~OPENDYNAMICSEXPLORER_TOOLTIP~ 
-- No icon yet
(
	on isEnabled return true
	on isChecked return false
	on isVisible return true
	on execute do
	(
		-- If the dynamics explorer has not been loaded yet, do it now.
		-- We rely on the explorer name "MassFX Explorer"/"Dynamics Explorer" as defined in the 
		-- InstanceName field of the "DefaultDynamicsExplorer.ini" file.
		if not SceneExplorerManager.ExplorerExists ~DYNAMICSEXPLORER_CAPTION~ then
		(
			local cfgpath = pathConfig.GetDir #plugcfg
			cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
			local cfgfile = pathConfig.appendPath cfgpath "DefaultDynamicsExplorer.ini"
			SceneExplorerManager.LoadExplorerConfiguration cfgfile
		)
		SceneExplorerManager.OpenExplorer ~DYNAMICSEXPLORER_TITLE~
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA7JhL10RsTmOzKBGwKeE57faD4JmbnoHMK
-- lciea1ippOO8pZLp0ERlf43UUBu8eIHLXx2MQK2qMBJ+9ccWcgMGjaMwKm2P3ld2
-- yP3BtXjvc/8wWUKfbqUYDOD0NtWgJk7LJWfWlpxpjSsGMAf0+KU7nqwUMvwU5Sxm
-- jRqXAIO6So57acc0rHzzY+hviF0l1SvQnNt+q1A7kMxuoI/u/MINGIBsQ4p0xNl+
-- l279e9j37AxuAhSMmFARUgJ7PsL35GkvcGSS4SYs+7ailhIDNIOcJvs3F1jDzo0B
-- 5jZpIvEL8o5xIdXdW226nvg5TCdZSchvRQ2pCtHbCv5Py1jmISmx
-- -----END-SIGNATURE-----